; *****************************************************
 ;  Progetto videogioco BURNER BUSTER (C) GAMECAST 2012
 ; *****************************************************
 ;  BURNER BUSTER v0.01 by AGsoftware 2009
 ;  MODE2IN1.BIN v1.0 by DanySoft
 ; *****************************************************
 ;  
 ; *****************************************************


 .org $C000 - 7

 .db $fe
 .dw startProgram,endProgram,startProgram

startProgram:    

LDIRVM .equ $005c ; routine del BIOS usata per riempire la VRAM
CHGMOD .equ $005f ; routine del BIOS usata per inizializzare lo schermo 
;(V9938)

CHRTBL1 .equ $0100 ; indirizzi tabelle delle forme +32*8
CHRTBL2 .equ $0900
CHRTBL3 .equ $1100

CLRTBL1 .equ $2100 ; indirizzi tabelle del colore +32*8
CLRTBL2 .equ $2900
CLRTBL3 .equ $3100

QTYFONT .equ $0300 ; 96*8 = 96 font

SPRTBL .equ $3800 ; indirizzi tabelle definizione sprites
SPRCLR .equ $1B00 ; indirizzi tabelle colore per sprites scr1



 ; Inizializza i registri del VDP.
writeVDP:

 di
 push af
 push bc
 push de
 push hl



 call $cc ; key off
 

 ;ld a,15 ; colore primo piano(scritte)
 ;ld ($f3e9),a ; indirizzo primo piano(scritte)
 ;ld a,1 ; colore sfondo
 ;ld ($f3ea),a ; indirizzo sfondo


 ld ix,$F3E9
 ld (ix+0),15	; colore primo piano
 ld (ix+1),1	; colore sfondo schermo
 ld (ix+2),1	; colore bordo dello schermo
 call $62		; chiama alla bios rom

;M1 M2 M3 M4 M5  Screen format
;1  0  0  0  0   Text                            (BASIC SCREEN 0)
;0  0  0  0  0   Half text                       (BASIC SCREEN 1)
;0  0  1  0  0   Hi resolution                   (BASIC SCREEN 2)
;0  1  0  0  0   Multicolour                     (BASIC SCREEN 3)
;0  0  0  1  0   Scrn2 with 8 Sprites/Line       (BASIC SCREEN 4)
;0  0  1  1  0   256*212, 16  colours/pixel      (BASIC SCREEN 5)
;0  0  0  0  1   512*212, 4   colours/pixel      (BASIC SCREEN 6)
;0  0  1  0  1   512*212, 16  colours/pixel      (BASIC SCREEN 7)
;0  0  1  1  1   256*212, 256 colours/pixel      (BASIC SCREEN 8)
;1  0  0  1  0   80 column text screen           (BASIC SCREEN0, WIDTH 80)

;Register 0:
;Mode register 0
;bit  Name  Expl.
;0    D     External video input (0=input disable, 1=enable)
;1    M3    Mode M3
;2    M4    Mode M4 (Not on MSX 1)
;3    M5    Mode M5 (Not on MSX 1)
;4    IE1   Horizontal Retrace Interrupt Enable
;5    IE0   Vertical Retrace Interrupt Enable
;6    DG    DiGitize mode
;7    0     Always 0

;Register 1:
;Mode register 1
;bit  Name  Expl.
;0    MAG   Sprite zoom          (0=x1, 1=x2)
;1    SZ    Sprite size          (0=8x8, 1=16x16)
;2    0     Always 0 on MSX 1
;3    M2    Mode M2
;4    M1    Mode M1
;5    IE2   Interrupt control (50Hz (PAL),
;           60 Hz (NTSC) and Light pen/mouse on
;           MVDP colour bus)             (0=Disable, 1=Enable)
;6    BLK   Screen output control        (0=Disable, 1=Enable)
;7    416   VRAM size control            (0=4K, 1=16K)



 ld a,1
 call CHGMOD  ; SCREEN1   
 
 LD HL,$F3B0 ; INDIRIZZO PER WIDTH (numero delle colonne da basic) 
 LD A,32     ; valore per 32 colonne full screen1
 LD (HL),A

;  ld a,1	;screen 1
;  call CHGMOD

 ; VDP(0)=4
 ld a,2
 out ($99),a
 ld a, 0
 or 128
 out ($99),a

 ; SCREEN,2 = VDP(1)=98 = SPRITE16X16
 ld a,98 ;224 ?
 out ($99),a
 ld a,1
 or 128	
 out ($99),a

 ; VDP(4)=3
 ld a,3
 out ($99),a
 ld a,4+128
 out ($99),a

 ; VDP(3)=255
 ld a,255
 out ($99),a
 ld a,3+128
 out ($99),a

 ; VDP(5)=63 for screen 4
 ; VDP(5)=54 for screen 1,2 !!!

 ld a,54
 out ($99),a
 ld a,5
 or 128
 out ($99),a

 ; Imposta la forma dei font
 ld hl,FONT_TBL
 ld de,CHRTBL1
 ld bc,QTYFONT
 call LDIRVM
 ld hl,FONT_TBL
 ld de,CHRTBL2
 ld bc,QTYFONT
 call LDIRVM
 ld hl,FONT_TBL
 ld de,CHRTBL3
 ld bc,QTYFONT
 call LDIRVM

 ; Imposta la tabella colore dei font
 ld hl,COLOR_TBL
 ld de,CLRTBL1
 ld bc,QTYFONT
 call LDIRVM
 ld hl,COLOR_TBL
 ld de,CLRTBL2
 ld bc,QTYFONT
 call LDIRVM
 ld hl,COLOR_TBL
 ld de,CLRTBL3
 ld bc,QTYFONT
 call LDIRVM


 ;Alloca la forma: 1UP in tabella ASCII
 ld hl,PLAYER1UP
 ld de,CHRTBL1+(128*8)-$100
 ld bc,8
 call LDIRVM
 ld hl,PLAYER1UP
 ld de,CHRTBL2+(128*8)-$100
 ld bc,8
 call LDIRVM
 ld hl,PLAYER1UP
 ld de,CHRTBL3+(128*8)-$100
 ld bc,8
 call LDIRVM

 ; Alloca il colore: 1UP in tabella ASCII
 ld hl,PLAYER1UP_COLOR
 ld de,CLRTBL1+(128*8)-$100
 ld bc,8
 call LDIRVM
 ld hl,PLAYER1UP_COLOR
 ld de,CLRTBL2+(128*8)-$100
 ld bc,8 
 call LDIRVM
 ld hl,PLAYER1UP_COLOR
 ld de,CLRTBL3+(128*8)-$100
 ld bc,8
 call LDIRVM

;Alloca la forma di: DEATH (MORTE il teschio) in tabella ASCII
 ld hl,DEATH
 ld de,CHRTBL1+(130*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,DEATH
 ld de,CHRTBL2+(130*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,DEATH
 ld de,CHRTBL3+(130*8)-$100
 ld bc,32*8
 call LDIRVM

;Alloca il colore di: DEATH (MORTE il teschio) in tabella ASCII
 ld hl,DEATH_COLOR
 ld de,CLRTBL1+(130*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,DEATH_COLOR
 ld de,CLRTBL2+(130*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,DEATH_COLOR
 ld de,CLRTBL3+(130*8)-$100
 ld bc,32*8
 call LDIRVM   

 ;Alloca la forma: TRUNK (bauletto), KEY, in tabella ASCII
 ld hl,TRUNK
 ld de,CHRTBL1+(144*8)-$100
 ld bc,8*8
 call LDIRVM
 ld hl,TRUNK
 ld de,CHRTBL2+(144*8)-$100
 ld bc,8*8
 call LDIRVM
 ld hl,TRUNK
 ld de,CHRTBL3+(144*8)-$100
 ld bc,8*8
 call LDIRVM

 ; Alloca il colore: TRUNK (bauletto), KEY, in tabella ASCII
 ld hl,TRUNK_COLOR
 ld de,CLRTBL1+(144*8)-$100
 ld bc,8*8
 call LDIRVM
 ld hl,TRUNK_COLOR
 ld de,CLRTBL2+(144*8)-$100
 ld bc,8*8
 call LDIRVM
 ld hl,TRUNK_COLOR
 ld de,CLRTBL3+(144*8)-$100
 ld bc,8*8
 call LDIRVM
     
;Alloca la forma di: CROSS, DOOR, SAFE, EXIT LEVEL in tabella ASCII
 ld hl,CROSS
 ld de,CHRTBL1+(168*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,CROSS
 ld de,CHRTBL2+(168*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,CROSS
 ld de,CHRTBL3+(168*8)-$100
 ld bc,32*8
 call LDIRVM

;Alloca il colore di: CROSS, DOOR, SAFE, EXIT LEVEL in tabella ASCII
 ld hl,CROSS_COLOR
 ld de,CLRTBL1+(168*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,CROSS_COLOR
 ld de,CLRTBL2+(168*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,CROSS_COLOR
 ld de,CLRTBL3+(168*8)-$100
 ld bc,32*8
 call LDIRVM          
 
  
;Alloca la forma di: albero magico, tank, in tabella ASCII
 ld hl,MAGICTREE
 ld de,CHRTBL1+(214*8)-$100
 ld bc,32*4
 call LDIRVM
 ld hl,MAGICTREE
 ld de,CHRTBL2+(214*8)-$100
 ld bc,32*4
 call LDIRVM
 ld hl,MAGICTREE
 ld de,CHRTBL3+(214*8)-$100
 ld bc,32*4
 call LDIRVM

;Alloca il colore di: albero magico, tank, in tabella ASCII
 ld hl,MAGICTREE_COLOR
 ld de,CLRTBL1+(214*8)-$100
 ld bc,32*4
 call LDIRVM
 ld hl,MAGICTREE_COLOR
 ld de,CLRTBL2+(214*8)-$100
 ld bc,32*4
 call LDIRVM
 ld hl,MAGICTREE_COLOR
 ld de,CLRTBL3+(214*8)-$100
 ld bc,32*4
 call LDIRVM          
 
;Alloca la forma di 'WALL' in tabella ASCII
 ld hl,WALL
 ld de,CHRTBL1+(230*8)-$100
 ld bc,8*4
 call LDIRVM
 ld hl,WALL
 ld de,CHRTBL2+(230*8)-$100
 ld bc,8*4
 call LDIRVM
 ld hl,WALL
 ld de,CHRTBL3+(230*8)-$100
 ld bc,8*4
 call LDIRVM

;Alloca il colore di 'WALL' in tabella ASCII
 ld hl,WALL_COLOR
 ld de,CLRTBL1+(230*8)-$100
 ld bc,8*4
 call LDIRVM
 ld hl,WALL_COLOR
 ld de,CLRTBL2+(230*8)-$100
 ld bc,8*4
 call LDIRVM
 ld hl,WALL_COLOR
 ld de,CLRTBL3+(230*8)-$100
 ld bc,8*4
 call LDIRVM
 
;Alloca la forma di: LAPIDE in tabella ASCII
 ld hl,LAPIDE
 ld de,CHRTBL1+(234*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,LAPIDE
 ld de,CHRTBL2+(234*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,LAPIDE
 ld de,CHRTBL3+(234*8)-$100
 ld bc,32*8
 call LDIRVM

;Alloca il colore di: LAPIDE in tabella ASCII
 ld hl,LAPIDE_COLOR
 ld de,CLRTBL1+(234*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,LAPIDE_COLOR
 ld de,CLRTBL2+(234*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,LAPIDE_COLOR
 ld de,CLRTBL3+(234*8)-$100
 ld bc,32*8
 call LDIRVM   
 
 
;Alloca la forma di: FLOWER in tabella ASCII
 ld hl,FLOWER
 ld de,CHRTBL1+(238*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,FLOWER
 ld de,CHRTBL2+(238*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,FLOWER
 ld de,CHRTBL3+(238*8)-$100
 ld bc,32*8
 call LDIRVM

;Alloca il colore di: FLOWER in tabella ASCII
 ld hl,FLOWER_COLOR
 ld de,CLRTBL1+(238*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,FLOWER_COLOR
 ld de,CLRTBL2+(238*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,FLOWER_COLOR
 ld de,CLRTBL3+(238*8)-$100
 ld bc,32*8
 call LDIRVM   
 
;Alloca la forma di: TREE in tabella ASCII
 ld hl,TREE
 ld de,CHRTBL1+(242*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,TREE
 ld de,CHRTBL2+(242*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,TREE
 ld de,CHRTBL3+(242*8)-$100
 ld bc,32*8
 call LDIRVM

;Alloca il colore di: TREE in tabella ASCII
 ld hl,TREE_COLOR
 ld de,CLRTBL1+(242*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,TREE_COLOR
 ld de,CLRTBL2+(242*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,TREE_COLOR
 ld de,CLRTBL3+(242*8)-$100
 ld bc,32*8
 call LDIRVM   
 
;Alloca la forma di: ABETE in tabella ASCII
 ld hl,ABETE
 ld de,CHRTBL1+(246*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,ABETE
 ld de,CHRTBL2+(246*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,ABETE
 ld de,CHRTBL3+(246*8)-$100
 ld bc,32*8
 call LDIRVM

;Alloca il colore di: ABETE in tabella ASCII
 ld hl,ABETE_COLOR
 ld de,CLRTBL1+(246*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,ABETE_COLOR
 ld de,CLRTBL2+(246*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,ABETE_COLOR
 ld de,CLRTBL3+(246*8)-$100
 ld bc,32*8
 call LDIRVM   

;Alloca la forma di: ICECUBE in tabella ASCII
 ld hl,ICECUBE
 ld de,CHRTBL1+(250*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,ICECUBE
 ld de,CHRTBL2+(250*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,ICECUBE
 ld de,CHRTBL3+(250*8)-$100
 ld bc,32*8
 call LDIRVM

;Alloca il colore di: ICECUB in tabella ASCII
 ld hl,ICECUBE_COLOR
 ld de,CLRTBL1+(250*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,ICECUBE_COLOR
 ld de,CLRTBL2+(250*8)-$100
 ld bc,32*8
 call LDIRVM
 ld hl,ICECUBE_COLOR
 ld de,CLRTBL3+(250*8)-$100
 ld bc,32*8
 call LDIRVM   


 ; Alloca la forma degli sprite
 ld hl,SPRDEF
 ld de,SPRTBL
 ld bc,32*37
 call LDIRVM 

;
 ld a,$6A
 ld hl,$27F8	;255x8 redraw giallo "COLORE CURSORE"
 ld bc,8
 call $56
 
 ld a,$6a
 ld hl,$2FF8
 ld bc,8
 call $56
 
 ld a,$6a
 ld hl,$37F8
 ld bc,8
 call $56
;
 pop hl
 pop de
 pop bc
 pop af
 ei
 ret ; torna al basic


FONT_TBL:
 ; Forma font 1o Set
 .db 000h,000h,000h,000h,000h,000h,000h,000h,018h,03Ch,03Ch,03Ch,018h,000h,018h,000h
 .db 06Ch,06Ch,048h,000h,000h,000h,000h,000h,06Ch,0FEh,06Ch,06Ch,06Ch,0FEh,06Ch,000h
 .db 018h,03Eh,058h,03Ch,01Ah,07Ch,018h,000h,000h,0C6h,0CCh,018h,030h,066h,0C6h,000h
 .db 070h,0C8h,0C8h,070h,09Ah,08Ch,076h,000h,018h,018h,010h,000h,000h,000h,000h,000h

 .db 00Ch,018h,030h,030h,030h,018h,00Ch,000h,030h,018h,00Ch,00Ch,00Ch,018h,030h,000h
 .db 000h,018h,05Ah,03Ch,03Ch,05Ah,018h,000h,000h,018h,018h,07Eh,018h,018h,000h,000h
 .db 000h,000h,000h,000h,018h,018h,008h,010h,000h,000h,000h,07Ch,000h,000h,000h,000h
 .db 000h,000h,000h,000h,000h,018h,018h,000h,000h,006h,00Ch,018h,030h,060h,0C0h,000h

 .db 038h,04Ch,0C6h,0C6h,0C6h,064h,038h,000h,018h,038h,018h,018h,018h,018h,07Eh,000h
 .db 07Ch,0C6h,00Eh,03Ch,078h,0E0h,0FEh,000h,07Eh,00Ch,018h,03Ch,006h,0C6h,07Ch,000h
 .db 01Ch,03Ch,06Ch,0CCh,0FEh,00Ch,00Ch,000h,0FCh,0C0h,0FCh,006h,006h,0C6h,07Ch,000h
 .db 03Ch,060h,0C0h,0FCh,0C6h,0C6h,07Ch,000h,0FEh,0C6h,00Ch,018h,030h,030h,030h,000h

 .db 07Ch,0C6h,0C6h,07Ch,0C6h,0C6h,07Ch,000h,07Ch,0C6h,0C6h,07Eh,006h,00Ch,078h,000h
 .db 000h,018h,018h,000h,018h,018h,000h,000h,000h,018h,018h,000h,018h,018h,008h,010h
 .db 00Ch,018h,030h,060h,030h,018h,00Ch,000h,000h,000h,07Ch,000h,07Ch,000h,000h,000h
 .db 060h,030h,018h,00Ch,018h,030h,060h,000h,07Ch,0C6h,006h,01Ch,030h,000h,030h,000h

 .db 03Ch,042h,099h,0A1h,0A1h,099h,042h,03Ch,038h,06Ch,0C6h,0C6h,0FEh,0C6h,0C6h,000h
 .db 0FCh,0C6h,0C6h,0FCh,0C6h,0C6h,0FCh,000h,03Ch,066h,0C0h,0C0h,0C0h,066h,03Ch,000h
 .db 0F8h,0CCh,0C6h,0C6h,0C6h,0CCh,0F8h,000h,0FEh,0C0h,0C0h,0F8h,0C0h,0C0h,0FEh,000h
 .db 0FEh,0C0h,0C0h,0F8h,0C0h,0C0h,0C0h,000h,03Eh,060h,0C0h,0CEh,0C6h,066h,03Eh,000h

 .db 0C6h,0C6h,0C6h,0FEh,0C6h,0C6h,0C6h,000h,07Eh,018h,018h,018h,018h,018h,07Eh,000h
 .db 006h,006h,006h,006h,006h,0C6h,07Ch,000h,0C6h,0CCh,0D8h,0F0h,0F8h,0DCh,0CEh,000h
 .db 0C0h,0C0h,0C0h,0C0h,0C0h,0C0h,0FEh,000h,0C6h,0EEh,0FEh,0FEh,0D6h,0C6h,0C6h,000h
 .db 0C6h,0E6h,0F6h,0FEh,0DEh,0CEh,0C6h,000h,07Ch,0C6h,0C6h,0C6h,0C6h,0C6h,07Ch,000h

 .db 0FCh,0C6h,0C6h,0C6h,0FCh,0C0h,0C0h,000h,07Ch,0C6h,0C6h,0C6h,0DEh,0CCh,076h,000h
 .db 0FCh,0C6h,0C6h,0CEh,0F8h,0DCh,0CEh,000h,078h,0CCh,0C0h,07Ch,006h,0C6h,07Ch,000h
 .db 07Eh,018h,018h,018h,018h,018h,018h,000h,0C6h,0C6h,0C6h,0C6h,0C6h,0C6h,07Ch,000h
 .db 0C6h,0C6h,0C6h,0EEh,07Ch,038h,010h,000h,0C6h,0C6h,0D6h,0FEh,0FEh,06Ch,044h,000h

 .db 0C6h,0EEh,07Ch,038h,07Ch,0EEh,0C6h,000h,066h,066h,066h,03Ch,018h,018h,018h,000h
 .db 0FEh,00Eh,01Ch,038h,070h,0E0h,0FEh,000h,0F8h,0C0h,0C0h,0C0h,0C0h,0C0h,0F8h,000h
 .db 000h,080h,040h,020h,010h,008h,000h,000h,0F8h,018h,018h,018h,018h,018h,0F8h,000h
 .db 000h,000h,020h,050h,088h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,0F8h

 ; Forma font 2o Set
 .db 03ch,042h,099h,0a1h,0a1h,099h,042h,03ch,038h,06ch,0c6h,0c6h,0feh,0c6h,0c6h,000h
 .db 0fch,0c6h,0c6h,0fch,0c6h,0c6h,0fch,000h,03ch,066h,0c0h,0c0h,0c0h,066h,03ch,000h
 .db 0f8h,0cch,0c6h,0c6h,0c6h,0cch,0f8h,000h,0feh,0c0h,0c0h,0f8h,0c0h,0c0h,0feh,000h
 .db 0feh,0c0h,0c0h,0f8h,0c0h,0c0h,0c0h,000h,03eh,060h,0c0h,0ceh,0c6h,066h,03eh,000h

 .db 0c6h,0c6h,0c6h,0feh,0c6h,0c6h,0c6h,000h,07eh,018h,018h,018h,018h,018h,07eh,000h
 .db 006h,006h,006h,006h,006h,0c6h,07ch,000h,0c6h,0cch,0d8h,0f0h,0f8h,0dch,0ceh,000h
 .db 0c0h,0c0h,0c0h,0c0h,0c0h,0c0h,0feh,000h,0c6h,0eeh,0feh,0feh,0d6h,0c6h,0c6h,000h
 .db 0c6h,0e6h,0f6h,0feh,0deh,0ceh,0c6h,000h,07ch,0c6h,0c6h,0c6h,0c6h,0c6h,07ch,000h
                                                                           
 .db 0fch,0c6h,0c6h,0c6h,0fch,0c0h,0c0h,000h,07ch,0c6h,0c6h,0c6h,0deh,0cch,076h,000h
 .db 0fch,0c6h,0c6h,0ceh,0f8h,0dch,0ceh,000h,078h,0cch,0c0h,07ch,006h,0c6h,07ch,000h
 .db 07eh,018h,018h,018h,018h,018h,018h,000h,0c6h,0c6h,0c6h,0c6h,0c6h,0c6h,07ch,000h
 .db 0c6h,0c6h,0c6h,0eeh,07ch,038h,010h,000h,0c6h,0c6h,0d6h,0feh,0feh,06ch,044h,000h
                                                                           
 .db 0c6h,0eeh,07ch,038h,07ch,0eeh,0c6h,000h,066h,066h,066h,03ch,018h,018h,018h,000h
 .db 0feh,00eh,01ch,038h,070h,0e0h,0feh,000h,0f8h,0c0h,0c0h,0c0h,0c0h,0c0h,0f8h,000h
 .db 000h,080h,040h,020h,010h,008h,000h,000h,0f8h,018h,018h,018h,018h,018h,0f8h,000h
 .db 000h,000h,020h,050h,088h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,0f8h
                                                                           
COLOR_TBL:

 ; Colore font 1o Set (sfumatura blu)
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h
 .db 040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h,040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

 ; Colore font 2o Set (sfumatura rossa)
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h

 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h

 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h

 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h
 .db 060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h,060h,080h,090h,090h,0f0h,0f0h,0f0h,0f0h

 ; Altri oggetti allocabili in tabella ASCII

PLAYER1UP:
  .DB 0,120,208,254,255,224,120,0
PLAYER1UP_COLOR:
  .DB 160,160,160,160,160,160,160,160

DEATH:
   .DB 15,31,57,57,31,7,1,3,3,0,112,14,1,14,112,0
   .DB 240,248,156,156,248,224,128,192,192,0,14,112,128,112,14,0
DEATH_COLOR:
   .DB 240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240
   .DB 240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240
   
TRUNK: ;TRUNK (bauletto)
       .DB 31,48,64,64,96,127,0,127,248,12,2,2,6,254,0,254    
       .DB 98,66,67,67,64,64,96,127,70,66,194,194,2,2,6,254    
 ; KEY YELLOW
       .db 30,51,97,65,65,99,63,1,0,0,0,0,0,0,0,0
       .db 0,0,0,0,0,0,128,192,224,112,56,28,14,7,30,12

TRUNK_COLOR: ; TRUNK (bauletto)
   .db 160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160
   .db 160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160
 ; KEY YELLOW COLOR
   .db 176,176,176,160,160,160,176,160,160,160,240,240,240,240,240,240
   .db 240,240,240,240,240,240,160,160,160,160,160,160,176,176,176,176
 
MAGICTREE: 
 ; MAGIC TREE PATTERN CHAR
  .DB 7,31,127,255,63,127,255,255,255,255,120,29,0,3,31,248
  .DB 56,188,190,255,255,255,255,254,140,192,224,224,224,254,231,32 
; TANK PATTERN CHAR  
  .DB 0,15,25,23,31,52,117,112,253,209,191,73,182,182,137,127
  .DB 0,0,128,255,192,112,220,126,127,67,253,34,217,217,34,252
;  SVASTICA DATA PATTERN
  .DB 0,7,31,62,38,102,102,96,96,126,126,48,48,31,7,0
  .DB 0,224,248,12,12,126,126,6,6,102,102,100,124,248,224,0
;  GATE GREY DATA PATTERN
  .DB 48,96,192,213,232,213,226,213,232,213,226,213,232,213,226,192
  .DB 0,0,1,85,139,85,35,85,171,85,35,85,139,85,35,1

MAGICTREE_COLOR:
; MAGIC TREE PATTERN CHAR COLOR
  .DB 192,192,192,192,192,192,48,48,32,32,192,192,240,144,144,144
  .DB 192,192,192,192,192,48,48,48,192,48,144,144,144,144,144,144 
; TANK PATTERN CHAR COLOR
  .DB 64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64
  .DB 64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64
; SVASTICA CHAR COLOR
  .DB 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
  .DB 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
; GATE GREY CHAR COLOR
  .DB 224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224
  .DB 224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224
    
WALL:
  .db 251,251,251,0,127,127,127,0
  .DB 251,251,251,0,127,127,127,0   
  .db 251,251,251,0,127,127,127,0
  .DB 251,251,251,0,127,127,127,0   
WALL_COLOR:
  .db 112,64,64,64,112,64,64,64         ; BLUE
  .DB 144,96,96,96,144,96,96,96         ; RED
  .DB 176,160,160,160,176,160,160,160   ; YELLOW
  .DB 48,32,32,32,48,32,32,32           ; GREEN
 
CROSS: ; casket 
   .DB 15,8,4,2,7,26,98,255,248,4,2,1,255,3,7,249
   .DB 136,133,135,128,237,237,128,255,145,17,21,21,177,177,18,252

 ; DOOR
       .DB 127,255,255,252,248,248,248,252,254,254,252,248,240,255,255,127
       .DB 254,255,255,63,31,31,31,63,127,127,63,31,15,255,255,254    

 ;SAFE (cassaforte)
       .DB 255,128,191,191,191,166,173,173,255,3,251,249,249,123,187,187   
       .DB 174,191,191,191,128,255,224,192,123,249,249,251,3,255,7,3
 ; EXIT LEVEL       
       .db 225,193,135,3,1,53,37,50,37,53,0,1,3,135,193,225
       .db 135,131,225,192,128,92,72,72,72,72,0,128,192,225,131,135
                                                                            
CROSS_COLOR:
 ; CASKET_COLOR 
    .db 112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112
    .db 112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112

 ; DOOR_COLOR
       .DB 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
       .DB 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192

 ;SAFE_COLOR  
 .db 224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224
 .db 224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224
 ; EXIT LEVEL    
       .db 71,71,71,71,71,135,135,135,135,135,135,71,71,71,71,71
       .db 71,71,71,71,71,135,135,135,135,135,135,71,71,71,71,71 
LAPIDE:
   .DB 0,1,3,1,15,31,63,63,63,53,48,63,59,48,63,63
   .DB 0,128,192,128,240,248,252,252,252,108,12,252,92,12,252,252
LAPIDE_COLOR:
   .DB 240,240,240,240,240,240,240,240,224,224,224,224,224,224,240,240
   .DB 240,240,240,240,240,240,240,240,224,224,224,224,224,224,240,240
FLOWER:
  .db 120,254,207,199,254,124,12,102,247,223,143,55,127,95,15,15
  .db 0,0,28,126,240,238,223,216,216,240,236,222,255,225,192,192

FLOWER_COLOR:
  .db 128,128,143,143,128,128,192,192,192,192,192,192,192,192,192,192
  .db 240,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192        
TREE:
   .DB 0,3,15,31,31,63,63,127,127,127,63,15,3,3,7,0
   .DB 0,192,240,248,248,252,252,254,254,254,252,240,192,192,224,0
TREE_COLOR:
   .DB 240,48,48,32,32,32,32,32,192,192,192,192,96,96,96,240
   .DB 240,48,48,48,32,32,32,32,32,192,192,192,96,144,144,240
ABETE:
  .DB 4,4,34,41,149,83,57,13,165,103,35,121,29,7,3,3
  .DB 160,160,200,138,146,252,225,198,204,241,198,200,220,240,192,192   
ABETE_COLOR:
  .DB 80,80,80,80,80,80,80,80,64,64,64,64,64,64,64,64
  .DB 80,80,80,80,80,80,80,80,64,64,64,64,64,64,64,64
ICECUBE:
   .DB 127,255,207,159,191,191,191,191,255,255,255,191,191,207,127,63
   .DB 248,254,230,250,250,254,254,254,254,254,254,250,242,230,254,252

ICECUBE_COLOR:
   .DB 64,64,71,71,71,71,71,71,64,64,64,71,71,71,64,64
   .DB 64,64,71,71,71,71,71,71,71,71,71,71,71,71,71,64 
SPRDEF:
; ROBY DX-A
      .DB 0,1,0,0,0,0,7,15,14,7,3,4,7,7,0,1
      .DB 0,64,0,0,0,0,192,224,240,96,112,224,240,240,0,240
      .DB 24,60,60,56,24,0,0,0,0,0,0,1,0,0,1,0
      .DB 0,0,0,0,0,0,0,0,0,0,128,0,0,0,192,0
      .DB 7,2,3,7,7,7,0,0,0,0,0,0,0,0,0,0
      .DB 192,128,240,248,0,192,0,0,0,0,0,0,0,0,0,0
; ROBY DX-B
       .DB 0,1,0,0,0,0,31,63,59,29,13,3,7,7,48,28
       .DB 0,64,0,0,0,0,192,224,224,224,224,240,200,131,6,12
       .DB 24,60,60,56,24,0,0,0,0,0,2,4,0,16,8,0
       .DB 0,0,0,0,0,0,0,0,0,0,0,0,48,120,24,0
       .DB 7,2,3,7,7,7,0,0,0,0,0,0,0,0,0,0
       .DB 192,128,240,248,0,192,0,0,0,0,0,0,0,0,0,0
; ROBY SX-A
       .DB 0,2,0,0,0,0,3,7,15,6,14,7,15,15,0,15
       .DB 0,128,0,0,0,0,224,240,112,224,64,32,224,224,0,128
       .DB 0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0
       .DB 24,60,60,28,24,0,0,0,0,0,0,128,0,0,128,0
       .DB 3,1,15,31,0,3,0,0,0,0,0,0,0,0,0,0
       .DB 224,64,192,224,224,224,0,0,0,0,0,0,0,0,0,0
; ROBY SX-B
       .DB 0,2,0,0,0,0,3,7,7,7,7,15,19,193,96,48
       .DB 0,128,0,0,0,0,248,252,220,184,176,192,224,228,12,56
       .DB 0,0,0,0,0,0,0,0,0,0,0,0,12,62,24,0
       .DB 24,60,60,28,24,0,0,0,0,0,64,32,0,24,48,0
       .DB 3,1,15,31,0,3,0,0,0,0,0,0,0,0,0,0
       .DB 224,64,192,224,224,224,0,0,0,0,0,0,0,0,0,0
; ROBY BACK-A
       .DB 0,0,0,0,0,31,63,119,119,63,31,15,15,15,0,7
       .DB 0,0,0,0,0,240,248,252,238,238,252,248,128,96,0,0
       .DB 0,4,15,15,7,0,0,0,0,0,0,0,0,0,3,0
       .DB 0,32,240,240,224,0,0,0,0,0,0,0,96,0,0,0
       .DB 3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       .DB 192,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; ROBY BACK-B
       .DB 0,0,0,0,0,15,31,63,119,119,63,31,1,6,0,0
       .DB 0,0,0,0,0,248,252,238,238,252,248,240,240,240,0,56
       .DB 0,4,15,15,7,0,0,0,0,0,0,0,6,0,0,0
       .DB 0,32,240,240,224,0,0,0,0,0,0,0,0,0,48,0
       .DB 3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       .DB 192,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; ROBY FRONT-A
       .DB 0,0,2,2,0,28,62,119,119,63,27,7,7,1,14,0
       .DB 0,0,64,64,0,48,120,252,238,238,220,232,240,248,0,112
       .DB 0,8,24,24,8,0,0,0,0,0,4,24,0,6,0,0
       .DB 0,16,24,24,16,0,0,0,0,0,32,16,8,0,96,0
       .DB 3,7,5,5,7,3,1,0,0,0,0,0,0,0,0,0
       .DB 192,224,160,160,224,192,128,0,0,0,0,0,0,0,0,0
;  ROBY FRONT-B
       .DB 0,0,2,2,0,12,30,63,119,119,59,23,15,31,0,14
       .DB 0,0,64,64,0,56,124,238,238,252,216,224,224,128,112,0
       .DB 0,8,24,24,8,0,0,0,0,0,4,8,16,0,6,0
       .DB 0,16,24,24,16,0,0,0,0,0,32,24,0,96,0,0
       .DB 3,7,5,5,7,3,1,0,0,0,0,0,0,0,0,0
       .DB 192,224,160,160,224,192,128,0,0,0,0,0,0,0,0,0
;  GHOST DX-1
  .DB 0,1,35,15,4,29,13,188,127,191,110,111,54,121,63,6
  .DB 224,240,248,252,114,10,216,216,4,251,127,186,120,240,192,0
;  GHOST SX-1
  .DB 7,15,31,63,78,80,27,27,32,223,254,93,30,15,3,0
  .DB 0,128,196,240,32,184,176,61,254,253,118,246,108,158,252,96
 
; 1UP DEATH (1UP MORTE) 
  .DB 0,0,0,0,0,0,0,1,67,3,67,3,3,1,0,0,
  .DB 31,0,15,15,15,15,175,255,255,159,111,238,220,128,0,0,
  
  .DB 0,0,0,0,0,0,0,0,0,0,0,0,96,248,248,112,
  .DB 0,7,0,0,0,0,0,0,0,32,16,0,0,0,0,0,
  
  .DB 0,0,0,0,0,16,48,48,180,244,188,252,156,0,0,0,
  .DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                                           
; DATA PATTERN FUMETTO COMICS con 6 sprites

  .DB 0,0,7,31,56,115,230,237,235,233,236,231,240,255,127,63
  .DB 7,255,255,249,57,249,25,201,107,43,107,203,59,255,243,243
  
  .DB 255,255,255,255,207,205,73,0,128,155,0,128,54,119,103,231
  .DB 255,255,255,225,196,156,220,249,97,199,207,79,207,255,207,207
  
  .DB 0,248,255,255,255,227,129,60,102,90,74,122,134,253,1,199
  .DB 0,0,128,240,248,206,207,207,159,159,159,191,191,254,60,56
  
  .DB 31,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  .DB 255,255,255,1,0,0,0,0,0,0,0,0,0,0,0,0  
  
  .DB 255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0
  .DB 255,255,255,255,3,3,7,6,12,0,0,0,0,0,0,0   
  
  .DB 255,255,254,224,128,0,0,0,0,0,0,0,0,0,0,0
  .DB 240,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0



 ; FRANK
      ; .DB 31,18,0,7,0,96,224,32,63,48,24,31,31,0,14,31
      ; .DB 248,168,0,224,0,6,7,7,255,15,27,248,248,0,48,0
      ; .DB 0,13,31,24,29,29,31,223,192,15,7,0,0,14,0,0
      ; .DB 0,80,248,24,184,184,248,248,0,240,224,3,0,112,0,0
      ; .DB 31,18,0,7,0,96,224,224,255,240,216,31,31,0,12,0
      ; .DB 248,168,0,224,0,6,7,4,252,12,24,248,248,0,112,248
      ; .DB 0,13,31,24,29,29,31,31,0,15,7,192,0,14,0,0
      ; .DB 0,80,248,24,184,184,248,251,3,240,224,0,0,112,0,0

 ; CAT GUARD
      ; .DB 4,14,31,31,57,0,0,0,16,63,63,31,31,15,7,4
      ; .DB 64,224,240,240,56,0,0,0,16,248,248,192,176,176,128,0
      ; .DB 0,0,0,0,0,62,127,63,14,0,64,192,0,48,56,24
      ; .DB 0,0,0,0,0,248,252,248,230,4,0,48,72,72,112,0
      ; .DB 4,14,31,31,57,32,0,0,16,63,63,7,27,27,3,0
      ; .DB 64,224,240,240,56,8,0,0,16,248,248,240,240,224,192,0
      ; .DB 0,0,0,0,0,30,127,63,206,64,0,24,36,36,28,0
      ; .DB 0,0,0,0,0,240,252,248,224,0,4,6,0,24,56,112

endProgram:


 .end
